#version 430 core
layout (location = 0) out vec4 screenTexture;

in vec2 TexCoords;

layout (binding = 0) uniform sampler2D image;

uniform float transparency;

uniform int isSplashScreen = 0;

void main()
{       
	
	vec4 screenTex = texture(image, TexCoords);

	if(isSplashScreen == 1){
		screenTexture.rgb = mix(vec3(0.0), screenTex.rgb, screenTex.a * transparency);
		screenTexture.a = screenTex.a * transparency;

	}else{
		screenTexture.rgb = screenTex.rgb;
		screenTexture.a = screenTex.a * transparency;
	}

}